<?php
    $u = auth()->user();
    $sess = (array) session('user', []);
    $sess_roles = collect((array)($sess['roles'] ?? []))->map(function($r){
        return is_array($r) ? strtolower($r['name'] ?? '') : strtolower((string)$r);
    });
    $sess_type = strtolower((string)($sess['user_type'] ?? ''));

    $has_role = false;
    try {
        if (method_exists($u, 'getRoleNames')) {
            $has_role = collect($u->getRoleNames())->map(fn($r)=>strtolower($r))->contains('supplier');
        } elseif (property_exists($u, 'roles') && $u->roles) {
            $has_role = collect($u->roles)->pluck('name')->map(fn($r)=>strtolower($r))->contains('supplier');
        }
    } catch (\Throwable $e) {}

    $is_supplier_user =
        ($u && (
            $has_role ||
            strtolower((string)($u->user_type ?? '')) === 'supplier' ||
            !empty($u->supplier_contact_id)
        )) ||
        $sess_roles->contains('supplier') ||
        ($sess_type === 'supplier') ||
        !empty($sess['supplier_contact_id'] ?? null);

    if ($is_supplier_user) {
        // Do not render the sidebar at all for Suppliers
        return;
    }
?>
<!-- Left side column. contains the logo and sidebar -->
<aside class="side-bar tw-relative tw-hidden tw-h-full tw-bg-white tw-w-64 xl:tw-w-64 lg:tw-flex lg:tw-flex-col tw-shrink-0">

    <!-- sidebar: style can be found in sidebar.less -->

    

    <a href="<?php echo e(route('home'), false); ?>"
        class="tw-flex tw-items-center tw-justify-center tw-w-full tw-border-r tw-h-15 tw-bg-<?php if(!empty(session('business.theme_color'))): ?><?php echo e(session('business.theme_color'), false); ?><?php else: ?><?php echo e('primary', false); ?><?php endif; ?>-800 tw-shrink-0 tw-border-primary-500/30">
        <p class="tw-text-lg tw-font-medium tw-text-white side-bar-heading tw-text-center">
            <?php echo e(Session::get('business.name'), false); ?> <span class="tw-inline-block tw-w-3 tw-h-3 tw-bg-green-400 tw-rounded-full" title="Online"></span>
        </p>
    </a>

    <!-- Sidebar Menu -->
    <?php echo Menu::render('admin-sidebar-menu', 'adminltecustom'); ?>


    <!-- /.sidebar-menu -->
    <!-- /.sidebar -->
</aside>
<?php /**PATH /home/adminkim/public_html/resources/views/layouts/partials/sidebar.blade.php ENDPATH**/ ?>